/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Macroscript Library for Autodesk Civil View                                            --***
***--   Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/

macroscript MCR12dImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_12DIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 3
)
macroscript MCRbuildingObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_BUILDINGOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenBuildingObjectsPanel()
)
macroscript MCRc3dImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_C3DIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenC3dImportPanel()
)
macroscript MCRchainageText category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_CHAINAGETEXT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenChainageTextTool()
)
macroScript MCRcreateDaylight category:~MACRO_CIVILVIEW_CATEGORY~ ButtonText:~MACRO_CREATEDAYLIGHT_TOOLTIP~ tooltip:~MACRO_CREATEDAYLIGHT_TOOLTIP~ icon:#("Systems",2)
(
  on execute do
  (
    --- We Need Command Panel to be open whilst doing this
    if not cui.commandPanelOpen then
    (
      local LOCtext = ~MACRO_CREATEDAYLIGHT_QUERY01~
      LOCtext += "\n\n"
      LOCtext += ~MACRO_CREATEDAYLIGHT_QUERY02~
      LOCtext += "\n\n"
      LOCtext += ~MACRO_CREATEDAYLIGHT_QUERY03~
      local LOCanswer = QueryBox LOCtext title:~MACRO_CREATEDAYLIGHT_TITLEBAR~ beep:false
      if LOCanswer then cui.commandPanelOpen = true
    )

    local LOCnodes = StartObjectCreation Daylight returnNewNodes:true
  )
  on isChecked return mcrUtils.IsCreating Daylight
)
macroscript MCRdrapeSpline category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DRAPESPLINE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDrapeSplineTool()
)
macroscript MCRdsimBearing category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMBEARING_TOOLTIP~ silenterrors:true
(
  DYNFUNpickVPbearing()
)
macroscript MCRdsimImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimImportPanel()
)
macroscript MCRdsimSubstitute category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMSUBSTITUTE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimSubstitutePanel()
)
macroscript MCRdsimSurface category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMSURFACE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimSurfacePanel()
)
macroscript MCRdxfImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DXFIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDxfImportPanel()
)
macroscript MCRexplorer category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_EXPLORER_TOOLTIP~ silenterrors:true
(
  if DYNmainFloater == undefined then DYNFUNopenExplorer()
)
macroscript MCRfeatureInterp category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_FEATUREINTERP_TOOLTIP~ silenterrors:true
(
  DYNFUNopenFeatureInterpPanel()
)
macroscript MCRgenioImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GENIOIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 1
)
macroscript MCRgRailObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GRAILOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopengRailObjectsPanel()
)
macroscript MCRimportMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_IMPORTMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenImportManDialog()
)
macroscript MCRlandXMLimport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_LANDXMLIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 4
)
macroscript MCRmakeForest category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_MAKEFOREST_TOOLTIP~ silenterrors:true
(
  DYNFUNmakeForest()
)
macroscript MCRmxImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_MXIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 2
)
macroscript MCRobjectPlacer category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OBJECTPLACER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenObjectPlacerPanel()
)
macroscript MCRopenHelp category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OPENHELP_TOOLTIP~ silenterrors:true
(
  DYNFUNopenHelp 13201 -- id_cv_civil_view_welcome 
)
macroscript MCRopenTutorials category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OPENTUTORIALS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenTutorials 13223 -- id_cv_tutorials
)
macroscript MCRplacedMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PLACEDMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPlacedManDialog()
)
macroscript MCRPointBasedPlace category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_POINTBASEDPLACE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenpointBasedPlaceTool()
)
macroscript MCRpreferences category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PREFERENCES_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPreferencesPanel 1
)
macroscript MCRproperties category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PROPERTIES_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPropertiesPanel()
)
macroscript MCRqparImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_QPARIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenQparImportPanel()
)
macroscript MCRresourceMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_RESOURCEMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenResourceManager 4 ""
)
macroscript MCRroadMarkings category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_ROADMARKINGS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenRoadMarkingsPanel()
)
macroscript MCRsightTool category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SIGHTTOOL_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSightToolPanel()
)
macroscript MCRsplineMapper category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SPLINEMAPPER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSplineMapperTool()
)
macroscript MCRsweptObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SWEPTOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSweptObjectsPanel()
)
